//
//  AppDelegate.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 04/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//

import UIKit
@UIApplicationMain

class AppDelegate: UIResponder, UIApplicationDelegate {
    var window: UIWindow?

    func application(application: UIApplication, didFinishLaunchingWithOptions launchOptions: [NSObject : AnyObject]?) -> Bool {
        CMSNetworkManager.sharedManagerWithUrl(k_WEBSERVICES_DOMAIN)
        CMS_Notification.registerForRemoteNotifications()
        return true
    }

    func applicationWillEnterForeground(application: UIApplication) {
        // To clear any existing badges and notifications when app entering foreground
        UIApplication.sharedApplication().cancelAllLocalNotifications()
        UIApplication.sharedApplication().applicationIconBadgeNumber = 0
    }
    
// MARK: RemoteNotificationRegister Callback Methods

    func application(application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: NSData) {
        var parsedDeviceToken = CMS_Notification.parseDeviceToken(deviceToken)
        CMS_Notification.notifyDeviceTokenToServer(parsedDeviceToken)
    }

    func application(application: UIApplication, didFailToRegisterForRemoteNotificationsWithError error: NSError?) {
        if error.code == 3010 {
            DLog("Push notifications are not supported in the iOS Simulator.")
        }
        else {
            //TODO: Show an alert or log regarding the error
            DLog("%@", error.description)
        }
    }

    func application(application: UIApplication, didReceiveRemoteNotification userInfo: [NSObject : AnyObject]) {
        DLog("userinfor = %@", userInfo)
        if application.applicationState == .Inactive {
            DLog("Received notifications while inactive.")
        }
        else {
            DLog("Received notifications while active.")
        }
    }
}